// Ovladani zalozek
document.addEventListener("DOMContentLoaded", function() {
    const tabs = document.querySelectorAll(".spx-tab");
    const contents = document.querySelectorAll(".spx-tab-content");

    function activateTab(tabId) {
        tabs.forEach(t => t.classList.remove("active"));
        contents.forEach(c => c.classList.remove("active"));

        document.querySelector(`[data-tab="${tabId}"]`).classList.add("active");
        document.getElementById(tabId).classList.add("active");

        // Aktualizace URL bez obnoveni stranky
        history.pushState(null, "", "?page=spx1mm-settings&tab=" + tabId);
    }

    tabs.forEach(tab => {
        tab.addEventListener("click", function() {
            let selectedTab = this.getAttribute("data-tab");
            activateTab(selectedTab);
        });
    });
});