<?php
/*
Description: Clearing various plugin caches
Version: 1
Updated: 2025-02-16 10:48:00
*/

// Vymazani ruznych cache pluginu
function spx1mm_vypniCache() {
    // Ziskani seznamu aktivnich pluginu
    $active_plugins = apply_filters('active_plugins', get_option('active_plugins'));

    /* Seznam podporovanych cache pluginu a jejich metod pro vymazani cache
    * WP Super Cache
    * W3 Total Cache
    * WP Fastest Cache
    * Cache Enabler
    * Autoptimize
    * LiteSpeed Cache
    * WP-Optimize
    * WP Rocket
    */

    // Podminky cache pluginy
    if (in_array('wp-super-cache/wp-cache.php', $active_plugins)) {
        if (function_exists('wp_cache_clear_cache')) {
            wp_cache_clear_cache();
        }
    }

    if (in_array('w3-total-cache/w3-total-cache.php', $active_plugins)) {
        if (function_exists('w3tc_flush_all')) {
            w3tc_flush_all();
        }
    }

    if (in_array('wp-fastest-cache/wpFastestCache.php', $active_plugins)) {
        if (class_exists('WpFastestCache')) {
            $wpfc = new WpFastestCache();
            if (method_exists($wpfc, 'deleteCache')) {
                $wpfc->deleteCache(true);
            }
        }
    }

    if (in_array('cache-enabler/cache-enabler.php', $active_plugins)) {
        if (function_exists('ce_cache_clear')) {
            ce_cache_clear();
        }
    }

    if (in_array('autoptimize/autoptimize.php', $active_plugins)) {
        if (class_exists('autoptimizeCache')) {
            autoptimizeCache::clearall();
        }
    }

    if (in_array('litespeed-cache/litespeed-cache.php', $active_plugins)) {
        if (function_exists('do_action')) {
            do_action('litespeed_purge_all');
        }
    }

    if (in_array('wp-rocket/wp-rocket.php', $active_plugins)) {
        if (function_exists('rocket_clean_domain')) {
            rocket_clean_domain();
        }
    }

    if (in_array('wp-optimize/wp-optimize.php', $active_plugins)) {
        if (class_exists('WP_Optimize') && method_exists('WP_Optimize', 'get_instance')) {
            $wp_optimize = WP_Optimize::get_instance();
            if (!empty($wp_optimize->cache) && method_exists($wp_optimize->cache, 'purge')) {
                $wp_optimize->cache->purge();
            }
        }
    }
}