<?php
// Add plugin-specific colors and fonts to the custom CSS
if (!function_exists('ureach_booked_get_css')) {
	add_filter('ureach_filter_get_css', 'ureach_booked_get_css', 10, 4);
	function ureach_booked_get_css($css, $colors, $fonts, $scheme='') {
		
		if (isset($css['fonts']) && $fonts) {
			$css['fonts'] .= <<<CSS

.booked-calendar-wrap .booked-appt-list .timeslot .timeslot-people button,
body #booked-profile-page input[type="submit"],
body #booked-profile-page button,
body .booked-list-view input[type="submit"],
body .booked-list-view button,
body table.booked-calendar input[type="submit"],
body table.booked-calendar button,
body .booked-modal input[type="submit"],
body .booked-modal button,
body #booked-profile-page .booked-profile-appt-list button.button-primary,
body #booked-profile-page input[type=submit],
body .booked-upload-wrap, body .booked-upload-wrap input,
body #booked-profile-page .booked-profile-appt-list .appt-block .booked-cal-buttons a,
body #booked-profile-page .appt-block .booked-cal-buttons .google-cal-button,
body #booked-profile-page .booked-profile-appt-list .appt-block .booked-fea-buttons > a.delete,
body #booked-profile-page .booked-profile-appt-list .appt-block .booked-fea-buttons > button.delete {
	{$fonts['button_font-family']}
	{$fonts['button_font-size']}
	{$fonts['button_font-weight']}
	{$fonts['button_font-style']}
	{$fonts['button_line-height']}
	{$fonts['button_text-decoration']}
	{$fonts['button_text-transform']}
	{$fonts['button_letter-spacing']}
}

CSS;
		
			
		$rad = ureach_get_border_radius();
		$css['fonts'] .= <<<CSS

body .booked-upload-wrap,
body #booked-profile-page input[type=submit],
body #booked-profile-page .booked-profile-appt-list button.button-primary,
body #booked-profile-page .booked-profile-appt-list .appt-block .booked-cal-buttons a,
body #booked-profile-page .appt-block .booked-cal-buttons .google-cal-button,
body #booked-profile-page .booked-profile-appt-list .appt-block .booked-fea-buttons > a.delete, 
body #booked-profile-page .booked-profile-appt-list .appt-block .booked-fea-buttons > button.delete,
body .booked-modal input[type=submit],
.cancel.button,
#submit-request-appointment {
	-webkit-border-radius: {$rad};
	    -ms-border-radius: {$rad};
			border-radius: {$rad};
}

CSS;
		}
		
		if (isset($css['colors']) && $colors) {
			$css['colors'] .= <<<CSS

/* Calendar */
table.booked-calendar th .monthName a {
	color: {$colors['extra_link']};
}
table.booked-calendar th .monthName a:hover {
	color: {$colors['extra_hover']};
}
.booked-calendar-wrap .booked-appt-list h2 {
	color: {$colors['text_dark']};
}
.booked-calendar-wrap .booked-appt-list .timeslot .timeslot-title {
	color: {$colors['text_link']};
}
.booked-calendar-wrap .booked-appt-list .timeslot .timeslot-time {
	color: {$colors['text_dark']};
}
.booked-calendar-wrap .booked-appt-list .timeslot .spots-available {
	color: {$colors['text']};
}

/* Form fields */
#booked-page-form {
	color: {$colors['text']};
	border-color: {$colors['bd_color']};
}

#booked-profile-page .booked-profile-header {
	background-color: {$colors['bg_color']} !important;
	border-color: transparent !important;
	color: {$colors['text']};
}
#booked-profile-page .booked-user h3 {
	color: {$colors['text_dark']};
}
#booked-profile-page .booked-profile-header .booked-logout-button:hover {
	color: {$colors['text_link']};
}

#booked-profile-page .booked-tabs {
	border-color: {$colors['alter_bd_color']} !important;
}

.booked-modal .bm-window p.booked-title-bar {
	background-color: {$colors['alter_dark']} !important;
}

.booked-calendarSwitcher.calendar,
.booked-calendarSwitcher.calendar select,
#booked-profile-page .booked-tabs {
	background-color: {$colors['alter_bg_color']} !important;
}
#booked-profile-page .booked-tabs li a {
	background-color: {$colors['alter_bg_color']};
	color: {$colors['alter_dark']};
}
table.booked-calendar thead,
table.booked-calendar thead th,
table.booked-calendar tr.days,
table.booked-calendar tr.days th,
#booked-profile-page .booked-tabs li.active a,
#booked-profile-page .booked-tabs li.active a:hover,
#booked-profile-page .booked-tabs li a:hover {
	color: {$colors['alter_dark']} !important;
	background-color: {$colors['extra_bg_hover']} !important;
}
table.booked-calendar tr.days,
table.booked-calendar tr.days th {
	border-color: {$colors['extra_bd_color']} !important;
}
table.booked-calendar thead th i {
	color: {$colors['extra_dark']} !important;
}
table.booked-calendar td.today .date span {
	border-color: {$colors['text_link']};
}
table.booked-calendar td:hover .date span {
	color: {$colors['text_dark']} !important;
}
table.booked-calendar td.today:hover .date span {
	background-color: {$colors['text_link']} !important;
	color: {$colors['inverse_link']} !important;
}
#booked-profile-page .booked-tab-content {
	background-color: {$colors['bg_color']};
	border-color: {$colors['alter_bd_color']};
}
table.booked-calendar td,
table.booked-calendar td+td {
	border-color: {$colors['alter_bd_color']};
}
body div.booked-calendar-wrap div.booked-calendar {
	background-color: {$colors['bg_color']};
}
body div.booked-calendar-wrap div.booked-calendar .bc-body .bc-row,
body div.booked-calendar-wrap div.booked-calendar .bc-body .bc-row:last-child {
	border-color: {$colors['alter_bd_color']};
}

body div.booked-calendar-wrap div.booked-calendar .bc-head,
body div.booked-calendar-wrap div.booked-calendar .bc-head .bc-row.top .bc-col {
	background: {$colors['extra_bg_color']} !important;
}

body div.booked-calendar-wrap div.booked-calendar .bc-head .bc-row.top .bc-col {
	border-color: {$colors['extra_bg_color']} !important;
}

body div.booked-calendar-wrap div.booked-calendar .bc-head .bc-row.days {
	border: 1px solid {$colors['bd_color']} !important;
}

body div.booked-calendar-wrap div.booked-calendar .bc-head .bc-row .bc-col .monthName,
body div.booked-calendar-wrap div.booked-calendar .bc-head .bc-row.days .bc-col {
	color: {$colors['inverse_link']} !important;
}
body div.booked-calendar-wrap div.booked-calendar .bc-head .bc-row.days .bc-col {
	border-color: {$colors['bd_color']} !important;
}

body div.booked-calendar-wrap div.booked-calendar .bc-head .bc-row .bc-col .page-right,
body div.booked-calendar-wrap div.booked-calendar .bc-head .bc-row .bc-col .page-left {
	color: {$colors['extra_bd_color']} !important;
}

.booked-calendar-wrap .booked-appt-list .timeslot .timeslot-people button:hover,
#submit-request-appointment:hover {
	color: {$colors['inverse_link']} !important;
	background: {$colors['text_hover']} !important;
}
body div.booked-calendar-wrap div.booked-calendar .bc-body .bc-row.week .bc-col.active:hover .date span {
	color: {$colors['alter_text']};
}
.mobile_layout .booked-calendar-wrap .booked-appt-list .timeslot .spots-available {
	color: {$colors['inverse_link']} !important;
}

/* New */
body div.booked-calendar-wrap div.booked-calendar .bc-body .bc-row.week div.bc-col {
	color: {$colors['text_dark']};
	border-color: {$colors['bd_color']};
}
body div.booked-calendar-wrap div.booked-calendar .bc-body .bc-row.week div.bc-col.next-month .date,
body div.booked-calendar-wrap div.booked-calendar .bc-body .bc-row.week div.bc-col.prev-month .date,
body div.booked-calendar-wrap div.booked-calendar .bc-body .bc-row.week div.bc-col.prev-date:hover .date,
body div.booked-calendar-wrap div.booked-calendar .bc-body .bc-row.week div.bc-col.prev-date .date {
	color: {$colors['alter_light']}!important;
}
body div.booked-calendar-wrap div.booked-calendar .bc-body .bc-row.week div.bc-col.today.active span.date,
body div.booked-calendar-wrap div.booked-calendar .bc-body .bc-row.week div.bc-col.active span.date {
	background-color: {$colors['alter_bg_hover']}!important;
}
body div.booked-calendar-wrap div.booked-calendar .bc-body .bc-row.week div.bc-col:not(.prev-date):hover span.date {
	background-color: {$colors['alter_bg_hover']}!important;
    color: {$colors['text_dark']}!important;
}
body div.booked-calendar-wrap div.booked-calendar .bc-body .bc-row.week div.bc-col.today.prev-date .date,
body div.booked-calendar-wrap div.booked-calendar .bc-body .bc-row.week div.bc-col.today .date {
	background-color: {$colors['extra_bg_color']}!important;
}
body div.booked-calendar-wrap div.booked-calendar .bc-body .bc-row.week div.bc-col.today.prev-date .date span {
    color: {$colors['extra_dark']}!important;
}
body div.booked-calendar-wrap div.booked-calendar .bc-body .bc-row.week div.bc-col.today:not(.active):not(:hover):not(.prev-date) .date span {
    color: {$colors['extra_dark']}!important;
}
body div.booked-calendar-wrap div.booked-calendar .bc-body .bc-row.entryBlock .bc-col {
	border: 20px solid {$colors['alter_bg_hover']};
}
body div.booked-calendar-wrap .booked-appt-list h2 {
	color: {$colors['text_dark']}!important;
}
body div.booked-calendar-wrap .booked-appt-list .timeslot .timeslot-time, body div.booked-calendar-wrap .booked-appt-list .timeslot .timeslot-people {
	color: {$colors['text_dark']};
}
body div.booked-calendar-wrap .booked-appt-list .timeslot .spots-available {
	color: {$colors['text_dark']};
}
body .booked-modal .bm-window p.booked-title-bar {
	background-color: {$colors['text_link']}!important;
}
body div.booked-calendar-wrap div.booked-calendar .bc-body {
	border: 1px solid {$colors['bd_color']}!important;
    margin-top: -1px;
}
body div.booked-calendar-wrap div.booked-calendar .bc-body .bc-row.week + .bc-row.week .bc-col {
	border-top: 1px solid {$colors['bd_color']};
}
body div.booked-calendar-wrap div.booked-calendar .bc-body .bc-row.week .bc-col.active .date,
body div.booked-calendar-wrap div.booked-calendar .bc-body .bc-row.week .bc-col.today:hover .date span {
	color: {$colors['text_dark']}!important;
}

body div.booked-calendar-wrap div.booked-calendar .booked-appt-list .timeslot+.timeslot {
    border-top: 1px solid {$colors['bd_color']};
}

/* Shortcodes */

body #booked-profile-page .booked-profile-appt-list .appt-block,
body #booked-profile-page .booked-profile-appt-list .appt-block > i.fa-solid,
body #booked-profile-page .booked-profile-appt-list .appt-block > strong {
	color: {$colors['text_light']}!important;
}
body #booked-profile-page .booked-profile-appt-list .appt-block.approved,
body #booked-profile-page .booked-profile-appt-list .appt-block.approved > i.fa-solid {
	color: {$colors['text_dark']};
}
body #booked-profile-page input[type=submit].button-primary,
body #booked-profile-page .appt-block .booked-cal-buttons .google-cal-button {
	color: {$colors['inverse_link']}!important;
	background: {$colors['text_link']}!important;
}
body #booked-profile-page input[type=submit].button-primary:hover,
body #booked-profile-page .appt-block .booked-cal-buttons .google-cal-button:hover {
	color: {$colors['inverse_link']}!important;
	background: {$colors['text_hover']}!important;
}
body #booked-profile-page .booked-profile-appt-list button.button-primary,
body .booked-upload-wrap,
body #booked-profile-page .booked-profile-appt-list .appt-block .booked-cal-buttons a {
	color: {$colors['inverse_link']};
	background-color: {$colors['text_hover']};
}
body .booked-upload-wrap span {
	color: {$colors['inverse_link']};
}
body #booked-profile-page .booked-profile-appt-list button.button-primary:hover,
body .booked-upload-wrap:hover,
body #booked-profile-page .booked-profile-appt-list .appt-block .booked-cal-buttons a:hover {
	color: {$colors['inverse_link']};
	background-color: {$colors['alter_bd_hover']};
}
body .booked-upload-wrap:hover span {
	color: {$colors['inverse_link']};
}
body #booked-profile-page .booked-profile-appt-list .appt-block .status-block {
	color: {$colors['alter_light']};
	background-color: {$colors['alter_bg_hover']};
}
body #booked-profile-page .booked-profile-appt-list .appt-block.approved .status-block {
	color: {$colors['inverse_link']};
	background-color: {$colors['text_link']};
}
body #booked-profile-page .booked-profile-appt-list .appt-block {
	border-color: {$colors['bd_color']};
}
body #booked-profile-page .booked-profile-appt-list .appt-block .booked-fea-buttons > a.delete, 
body #booked-profile-page .booked-profile-appt-list .appt-block .booked-fea-buttons > button.delete {
	color: {$colors['inverse_link']};
	background-color: {$colors['text_link']};
}
body #booked-profile-page .booked-profile-appt-list .appt-block .booked-fea-buttons > a.delete:hover, 
body #booked-profile-page .booked-profile-appt-list .appt-block .booked-fea-buttons > button.delete:hover {
	color: {$colors['inverse_link']};
	background-color: {$colors['text_hover']};
}

body #booked-profile-page .booked-profile-header .booked-logout-button {
	color: {$colors['text_link']};
}

body #booked-profile-page .booked-profile-header .booked-logout-button:hover {
	color: {$colors['text_hover']};
}

body .booked-modal .bm-window,
body .booked-modal .bm-window .booked-scrollable {
	background-color: {$colors['bg_color']}!important;
}
body .booked-modal .booked-form .booked-appointments,
#customerChoices {
	color: {$colors['alter_dark']}!important;
	background-color: {$colors['extra_bg_hover']}!important;
}
#customerChoices {
	border-color: {$colors['alter_bd_color']}!important;
}

body .booked-form .field select,
body .booked-form .field input[type=text],
body .booked-form .field input[type=password],
body .booked-form .field input[type=tel],
body .booked-form .field input[type=email],
body .booked-form .field textarea {
	color: {$colors['input_text']}!important;
	border-color: {$colors['input_bd_color']}!important;
	background-color: {$colors['input_bg_color']}!important;
}

CSS;
		}

		return $css;
	}
}
?>