<?php
/* QuickCal Appointments support functions
------------------------------------------------------------------------------- */

// Theme init priorities:
// 9 - register other filters (for installer, etc.)
if (!function_exists('ureach_quickcal_theme_setup9')) {
	add_action( 'after_setup_theme', 'ureach_quickcal_theme_setup9', 9 );
	function ureach_quickcal_theme_setup9() {
		if (ureach_exists_quickcal()) {
			add_action( 'wp_enqueue_scripts', 							'ureach_quickcal_frontend_scripts', 1100 );
			add_filter( 'ureach_filter_merge_styles',					'ureach_quickcal_merge_styles' );
		}
		if (is_admin()) {
			add_filter( 'ureach_filter_tgmpa_required_plugins',		'ureach_quickcal_tgmpa_required_plugins' );
		}
	}
}

// Check if plugin installed and activated
if ( !function_exists( 'ureach_exists_quickcal' ) ) {
	function ureach_exists_quickcal() {
		return class_exists('quickcal_plugin');
	}
}

// Filter to add in the required plugins list
if ( !function_exists( 'ureach_quickcal_tgmpa_required_plugins' ) ) {
	
	function ureach_quickcal_tgmpa_required_plugins($list=array()) {
		if (in_array('quickcal', ureach_storage_get('required_plugins'))) {
			$path = ureach_get_file_dir('plugins/quickcal/quickcal.zip');
			$list[] = array(
					'name' 		=> esc_html__('QuickCal', 'ureach'),
					'slug' 		=> 'quickcal',
					'version'	=> '1.0.14',
					'source' 	=> !empty($path) ? $path : 'upload://quickcal.zip',
					'required' 	=> false
			);
		}
		return $list;
	}
}
	
// Enqueue plugin's custom styles
if ( !function_exists( 'ureach_quickcal_frontend_scripts' ) ) {
	
	function ureach_quickcal_frontend_scripts() {
		if (ureach_is_on(ureach_get_theme_option('debug_mode')) && ureach_get_file_dir('plugins/quickcal/quickcal.css')!='')
			wp_enqueue_style( 'ureach-quickcal',  ureach_get_file_url('plugins/quickcal/quickcal.css'), array(), null );
	}
}
	
// Merge custom styles
if ( !function_exists( 'ureach_quickcal_merge_styles' ) ) {
	
	function ureach_quickcal_merge_styles($list) {
		$list[] = 'plugins/quickcal/quickcal.css';
		return $list;
	}
}


// Add plugin-specific colors and fonts to the custom CSS
if (ureach_exists_quickcal()) { require_once UREACH_THEME_DIR . 'plugins/quickcal/quickcal.styles.php'; }
?>